/*  Berechnet den Endzeitpunkt für eine Transport- und oder Liegeoperation, bei einem gegebenen Startzeitpunt und einem gegebenen Weg.

    Der Weg gibt an, von welcher zu welcher Resource transportiert werden soll.

    Bei der Berechnung des Zeitpunkts wird ein Richtungsfaktor einbezogen.
    Dieser Faktor bestimmt die Richtung der Berechnung. Ist der Faktor negativ, wird für einen gegebenen Endzeitpunkt ein
    Startzeitpunkt berechnet.
    Der Faktor kann den Transport aber auch verlangsamen (Betrag des Faktors kleiner null) oder beschleunigen (Betrag des
    Faktors größer null).

    Neben der reinen Transportzeit kann die Funktion eine ggf. exisitierende Liegezeit einbeziehen.
    Transportzeit + Liegezeit = minimaler Buffer
*/
-- Für Transportzeitermittleung eigene Funktion "timediff_addsubstdays" erstellt.
-- Ursprüngliche Funktion nimmt das Wochenende mit dazu, wenn sich das Wochenende direkt am errechneten Ende der Transportzeit
-- anschließt. Nicht so gewollt. Sonst kann es beim Rückwärtsterminieren mit Packen knallen.
-- Zeit-Differenz Tage vor oder zurück (_substWE: Wochenenden rausnehmen,  _substFT: _feiertage rausnehmen)
SELECT tsystem.function__drop_by_regex( 'timediff_addsubstdays_term', _commit => true );
CREATE OR REPLACE FUNCTION timediff_addsubstdays_term(
      _danf timestamp,
      _addsubstdays numeric,
      _substWE boolean = true,
      _substFT boolean = true
  ) RETURNS timestamp AS $$
  DECLARE
      _end_date  timestamp;
      _day_step  interval;
      _i         integer;
      _feiertage date[];
  BEGIN
      IF _danf IS null OR COALESCE( _addsubstdays::integer, 0 ) = 0 THEN
          RETURN _danf;
      END IF;

      _end_date := _danf;
      _day_step := sign( _addsubstdays ) * '1 day'::interval; -- Tag vorwärts oder rückwärts. Richtung bei 0 nicht entscheidbar.

      IF _substWE OR _substFT THEN
          IF _substFT THEN -- Performance: _feiertage nicht per EXISTS pro Tag, sondern Array
            _feiertage:= (
                            SELECT array_agg( ft_date )
                              FROM feiertag
                              WHERE NOT ft_urlaub
                                AND CASE WHEN sign( _addsubstdays ) = -1
                                        THEN ft_date BETWEEN date_trunc( 'year', _danf::date - abs( _addsubstdays::integer ) - '1 year'::interval )::date AND _danf::date -- wenn rückwärts Feiertag des vorigen Jahres bis heute in Array
                                        ELSE ft_date BETWEEN _danf::date AND date_trunc( 'year', _danf::date + abs( _addsubstdays::integer ) + '2 year'::interval )::date -- wenn vorwärts Feiertag bis Ende des nächsten Jahres in Array
                                    END
                          );
          END IF;

          FOR _i IN 1 .. abs( _addsubstdays::integer) LOOP -- bei 1 .. 0 kein LOOP
              -- Muss im WHILE immer auf WE oder Feiertag geprüft werden, da Folgetag das jeweils andere sein kann.
              WHILE ( _substWE AND CASE WHEN sign( _addsubstdays ) = -1 THEN EXTRACT( dow FROM ( _end_date - interval '1 day' ) ) ELSE EXTRACT( dow FROM _end_date ) END IN ( 0, 6 ) ) -- Prüfung WE, wenn Rückwärts und 0:00 Uhr im _end_date, dann gehe zum Vortag (-1 day)
                    OR
                    ( _substFT AND CASE WHEN sign( _addsubstdays ) = -1 THEN (_end_date - interval '1 day' )::date ELSE _end_date::date END = ANY( _feiertage ) ) -- Prüfung Feiertag, wenn Rückwärts und 0:00 Uhr im _end_date, dann gehe zum Vortag (-1 day)
              LOOP
                  _end_date:= _end_date + _day_step;
              END LOOP;
              _end_date:= _end_date + _day_step;
          END LOOP;
      ELSE
          _end_date:= _end_date + _addsubstdays::integer * '1 day'::interval;
      END IF;

      RETURN _end_date;
  END $$ LANGUAGE plpgsql STABLE;


SELECT tsystem.function__drop_by_regex( 'resource__transport_time__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource__transport_time__get(
      _time_start timestamp,
      _resource_id_from int,
      _resource_id_to int,
      _direction_factor int = 1,
      _lgz int = 0,
      _loglevel int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
  ) RETURNS timestamp AS $$
  DECLARE
      _resource_transport_record scheduling.resource_transport;
      _ksvba_from ksvba;
      _ksvba_to   ksvba;
  BEGIN

      -- Debug
      IF _loglevel >= 4 THEN
          RAISE NOTICE '%', format(
                                      'call: scheduling.resource__transport_time__get( _time_start => %L, _resource_id_from => %L, _resource_id_to => %L, _direction_factor => %L, _lgz => %L, _loglevel => %L )',
                                                                                       _time_start      , _resource_id_from      , _resource_id_to      , _direction_factor      , _lgz      , _loglevel
                                  )
          ;
      END IF;

      -- Sicherstellen dass die Liegezeit wirklich eine Zahl ist.
      _lgz := coalesce( _lgz, 0 );

      IF ( _resource_id_from = _resource_id_to ) OR _resource_id_from IS null OR _resource_id_to IS null THEN
          RETURN _time_start + ( _lgz * _direction_factor ) * '1s'::interval;
      END IF;


      -- Transportmatrix-Eintrag einlesen.
      _resource_transport_record :=
          t
          FROM scheduling.resource_transport t
          WHERE
                resource_id_from = _resource_id_from
            AND resource_id_to   = _resource_id_to
        ;

      -- Prüfen, ob Transportmatrix-Eintrag fehlt, dann Transportmatrix-Eintrag erstellen.
      -- TODO hier könnte man einfach auf die Defaults gehen (scheduling.resource__transport_time_defaults__get). Dann würde man nur noch die Einträge haben, welche abweichend der Defaults sind. Weiterhin könnte man einfacher Defaults verändern
      IF ( _resource_transport_record IS NULL ) THEN
          RAISE WARNING 'resource_transport empty. calling ksvba__resource__transport_update(%, %)', _resource_id_from, _resource_id_to;
          _ksvba_from := t FROM scheduling.resource, ksvba t WHERE id = _resource_id_from AND ksb_id = context_id;
          _ksvba_to   := t FROM scheduling.resource, ksvba t WHERE id = _resource_id_to   AND ksb_id = context_id;

          IF _ksvba_from IS null THEN
             RAISE EXCEPTION '_ksvba_from not found. ksb_id: %', _resource_id_from;
          END IF;
          IF _ksvba_to IS null THEN
             RAISE EXCEPTION '_ksvba_to not found. ksb_id: %', _resource_id_to;
          END IF;

          PERFORM scheduling.ksvba__resource__transport_update(_ksvba_from, _ksvba_to);

          -- Transportmatrix-Eintrag einlesen.
          _resource_transport_record :=
              t
              FROM scheduling.resource_transport t
              WHERE
                    resource_id_from = _resource_id_from
                AND resource_id_to   = _resource_id_to
          ;

          -- Wenn Transportmatrix-Eintrag immer noch leer, dann Fehler ausgeben.
          IF ( _resource_transport_record IS NULL ) THEN
              RAISE EXCEPTION 'illegal resource_ids provided, from: %, to: %. resource_transport seems empty check ksvba__resource__transport_update', _resource_id_from, _resource_id_to;
          END IF;
      END IF;

      -- TODO AXS: Wofür ist das???
      IF ( _resource_transport_record.work_required > 0 ) THEN
          RAISE EXCEPTION 'work time not implemented';
      END IF;

      -- if buffertime larger than one day, we truncate the result
      -- and use the timediff_addsubstdays, which is aware of weekends
      -- this will fail on resources, which work at the workends!
      -- Todo => Code Doppelung siehe UNTEN!
      IF ( _resource_transport_record.buffer_time + _lgz >= 60*60*24 ) THEN
          -- Teilweise belastete Tage gelten vollständig als belastet. Daher bei "vorwärts" ab einen Tag später die DLZ berechnen.
          IF _direction_factor = 1 AND ( _time_start > date_trunc( 'day', _time_start ) ) THEN
              _time_start := _time_start + interval '1 day';
          END IF;
          --
          RETURN date_trunc(
                    'day',
                    public.timediff_addsubstdays_term( _time_start, ( _resource_transport_record.buffer_time + _lgz )::int / ( 60*60*24 ) * _direction_factor )
                );
      END IF;

      -- default case, just add time
      RETURN _time_start + ( ( _resource_transport_record.buffer_time + _lgz ) * _direction_factor ) * '1s'::interval;

  END $$ LANGUAGE plpgsql STABLE;

DROP FUNCTION IF EXISTS scheduling.resource__transport_time_defaults__get;
CREATE OR REPLACE FUNCTION scheduling.resource__transport_time_defaults__get(
    _time_start timestamp,
    _ab2_from ab2,
    _ab2_to ab2,
    _direction_factor int = 1,
    _lgz int = 0
    ) 
    RETURNS timestamp 
    AS $$  
    DECLARE _resource_transport_record______buffer_time integer; -- _resource_transport_record.buffer_time
    BEGIN
      _resource_transport_record______buffer_time :=        scheduling.ksvba__resource__transport_defaults(coalesce(a2wf.a2w_oks, _ab2_from.a2_ks), coalesce(a2wt.a2w_oks, _ab2_to.a2_ks)) 
                                                       FROM ab2_wkstplan a2wf, ab2_wkstplan a2wt
                                                      WHERE a2wf.a2w_a2_id = _ab2_from.a2_id
                                                        AND a2wt.a2w_a2_id = _ab2_to.a2_id;

      -- if buffertime larger than one day, we truncate the result
      -- and use the timediff_addsubstdays, which is aware of weekends
      -- this will fail on resources, which work at the workends!
      -- Todo => Code Doppelung siehe UNTEN!
      IF ( _resource_transport_record______buffer_time + _lgz >= 60*60*24 ) THEN
          -- Teilweise belastete Tage gelten vollständig als belastet. Daher bei "vorwärts" ab einen Tag später die DLZ berechnen.
          IF _direction_factor = 1 AND ( _time_start > date_trunc( 'day', _time_start ) ) THEN
              _time_start := _time_start + interval '1 day';
          END IF;
          --
          RETURN date_trunc(
                    'day',
                    public.timediff_addsubstdays_term( _time_start, ( _resource_transport_record______buffer_time + _lgz )::int / ( 60*60*24 ) * _direction_factor )
                );
      END IF;

      -- default case, just add time
      RETURN _time_start + ( ( _resource_transport_record______buffer_time + _lgz ) * _direction_factor ) * '1s'::interval;          
    END $$ LANGUAGE plpgsql;

/*
 => FUNCTION scheduling.ksvba__resource__transport_defaults(ks_abt__from varchar, ks_abt__to varchar) 
CREATE OR REPLACE FUNCTION scheduling.resource__transport_time__get(
      _time_start timestamp,
      _ab2_from ab2,
      _ab2_to ab2,
      _direction_factor int = 1,
      ) 
      RETURNS timestamp 
      AS $$  
  
          SELECT max(scheduling.resource__transport_time__get(_time_start,
                                                                _resource_id_from,  _resource_id_to
                                                                ,_direction_factor
                                                               )
                    )
            FROM ab2 _ab2_from, unnest(scheduling.ab2__resources__find_possible__ksvba_ksb_id__by__ab2__get( _ab2_from ) ) AS _resource_id_from, 
                 ab2 _ab2_to,   unnest(scheduling.ab2__resources__find_possible__ksvba_ksb_id__by__ab2__get( _ab2_to ) )   AS _resource_id_to,
                 --scheduling.resource_transport t -- invalide kombinationen erst gar nicht nehmen
                 -- alternaiv ab2__resources__find_possible__ksvba_ksb_id__by__ab2__get > hier nur die erste relevante und die matrix zu verkleinern? analog "-- append single workplace" nur eine zurückgeben als default?
         -- WHERE
           --     resource_id_from = _resource_id_from
           -- AND resource_id_to   = _resource_id_to
           --WHERE _ab2_from.a2_ab_ix = 241039 AND _ab2_from.a2_n = 60 AND _ab2_to.a2_ab_ix = 241039 AND _ab2_to.a2_n = 50
      $$ LANGUAGE sql;
*/      